<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-project-innovation-initiative
* @subpackage controllers
* @filesource
*/ /** */

require_once APPPATH.'controllers/inbox.php';
require_once 'Mail/mimeDecode.php';

/**
* @package direct-project-innovation-initiative
* @subpackage controllers
*/
class Attachment_controller extends Inbox {
		
	//attaches a single file
    function attach() {					
		//this seems weird.  is this really right?   -- MG 2014-04-17	
		if(empty($_FILES) && empty($_POST) && strtolower(element('REQUEST_METHOD', $_SERVER)) == 'post') 
			return $this->show_attachment_error('Unable to upload '.$filename.'; adding this file would exceed the maximum size limit for attachments', 413);
			
		if(!isset($_FILES['attach'])) show_404(); //preserving the orginal code, but this seems like a strange response.  wouldn't it be more consistent to do a bad request response?  -- MG 2014-04-17	
		
		//make sure we have a file to attach
		$filename = element('name', element('attach', $_FILES, array()));
		if(empty($filename)) return $this->show_attachment_error('Bad Request', 400);
		if(!Message::attachment_has_valid_extension($filename)) return $this->show_attachment_error('Invalid file type', 400);
		
#TODO - THIS WOULD BE AN EXCELLENT PLACE TO RENAME THE FILE IF IT EXISTS IN THE CACHE ALREADY	
		
		//first, make sure we have a cache - we won't if this is the first attachment for this message
		if(!directory_exists($this->user->attachment_cache())) mkdir($this->user->attachment_cache()); //attempt to create the cache if needed
		if(!directory_exists($this->user->attachment_cache())) return $this->error->warning('Could not create an attachment cache for '.$this->user->describe().' at '.$this->user->attachment_cache());
		
		//check to make sure that we don't already have a file with this name in the cache - change the name if needed
		$existing_filenames = get_filenames($this->user->attachment_cache());
		$extension = substr($filename, strpos($filename, '.'));
		$filename = strip_from_end($extension, $filename); //temporarily remove the extension from the filename so that we can add the numbers
			
		//if we have duplicate file names, make them unique by adding a number (#) to each one
		for($i = 1; in_array($filename.$extension, $existing_filenames); $i++){
			//make sure to clear out any parentheses that we've added.  Note that we'll have to do this even for things we didn't add so that we don't mess things up while re-saving.
			if(preg_match('/\(\d+\)$/', $filename, $matches)) {
				$filename = trim(strip_from_end(first_element($matches), $filename)); //clear out any numbers that we've added already
			}
			$filename = $filename.' ('.$i.')';
		}
		$filename = $filename.$extension;			
					
		//add the file to the cache if possible
		$success = move_uploaded_file($_FILES['attach']['tmp_name'], $this->user->attachment_cache().'/'.$filename);
		if(!$success) return $this->show_attachment_error('Unable to upload file '.$filename, 400);

		//check the current size of the cache
		if($this->user->attachment_cache_size_in_bytes() > MAX_ATTACHMENTS_SIZE*(1048576)) {
			$this->clear_attachment($filename);
			return $this->show_attachment_error('Unable to upload '.$filename.'; adding this file would exceed the maximum size limit for attachments', 413);
		}
		
		$filesize = filesize($this->user->attachment_cache().'/'.$filename);
		$token = $this->security->get_csrf_hash();
		$success_message = json_encode(compact('token', 'filename', 'filesize'));
		
		if(IS_AJAX)
			echo $success_message;
		else
			echo '<textarea status="200">'.$success_message.'</textarea>';

    }
	
	public function clear_attachment($filename) {
		if(!directory_exists($this->user->attachment_cache())) return true; //we're done!
		
		$filename = html_entity_decode(rawurldecode($filename));
		$path = $this->user->attachment_cache().$filename;
		if(!file_exists($path)) return true; //we're done!
		if(!unlink($path)) show_error('Failed remove attachment '.$filename.' due to internal error.', 500);
		return true;
    }		
	
	
#TODO - ADAM SAID PREVIOUSLY THAT WE SHOULD ALLOW MULTIPLE FILES WITH THE SAME NAME, BUT THIS METHOD IDENTIFIES ATTACHMENTS BY NAME -- NEED A DIFFERENT UNIQUE ID IF WE'RE GOING FOR MULTIPLE FILES WITH SAME NAME	
    public function get_attachment($message_id, $filename, $download = NULL, $download_type = NULL) {
		if(!Message::formatted_like_an_id($message_id)) show_404();
		if(!$this->is->nonempty_string($filename)) show_404();
		
		//find the message && validate
		$message = Message::find_one($message_id);
		$this->show_error_if_not_a_message($message);
		
		$filename = html_entity_decode(rawurldecode($filename));
		$file_type = pathinfo($filename, PATHINFO_EXTENSION);	
		
		if(array_key_exists($filename, $message->attachment_files())){
			$attachment = element($filename, $message->attachment_files());
		}elseif(array_key_exists($filename, $message->inline_attachment_files())){
			$attachment = element($filename, $message->inline_attachment_files());
		}else{
			show_404();  //attachment doesn't exist
		}
			
		$string = $attachment->binary_string;
		
		if($file_type === 'pdf') {
			header('Content-Type: application/pdf');
			header('Content-Disposition: inline; filename="' . $filename . '"');
			echo $string;
		}
		else if(($file_type == 'jpg' || $file_type == 'jpeg' || $file_type == 'png' || $file_type == 'gif') && (!is_null($download) && $download === 'download')) {
				header('Content-Type: application/octet-stream');
				header('Content-Disposition: attachment; filename="' . $filename . '"');
				header('Content-Transfer-Encoding: binary');
				echo $string;
			}
		else if($file_type === 'jpg' || $file_type === 'jpeg' || $file_type === 'png' || $file_type === 'gif') {
			header('Content-Type: image/'. $file_type);
			header('Content-Disposition: inline; filename="' . $filename . '"');
			echo $string;
		}
		else if($file_type == 'xml' && (!is_null($download) && $download == "download") && (is_null($download_type))) {
			header("Content-Type: application/force-download");
			header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
			header("Content-Transfer-Encoding: binary");
			echo $string;
		}
		else if($file_type == 'xml') {
			$xml = new DOMDocument; //load xml
			$xml->loadXml($string);
			//get schema to check if its a c32
			$schema = $xml->documentElement->getAttribute('xsi:schemaLocation'); 
			if(strpos($schema,"cdar2c32") !== FALSE || strpos($schema,"v3 CDA") !== FALSE) {
				$xsl_location = APPPATH.'views/xsl/cda2detail.xsl'; //TO-DO: make config item?
				$xsl_string = file_get_contents($xsl_location);
				if(isset($xsl_string) && $xsl_string) {
					$xsl = new DOMDocument; //load xsl
					$xsl->loadXml($xsl_string);
					$proc = new XSLTProcessor;
					$proc->importStyleSheet($xsl); // attach the xsl rules
					$transform = $proc->transformToXML($xml);
					if($transform) { 

						if((!is_null($download) && $download == "download") && (!is_null($download_type) && $download_type == "pdf"))
						{ 
							//only run the pdf generation code if we're displaying a pdf, yes?
							#TODO - would be much better to name this file after the $filename instead of just temp - the user cache is used for all of a user's messages, we want to reduce naming collisions -- MG
							if(!directory_exists($this->user->attachment_cache())) { mkdir($this->user->attachment_cache()); }
							file_put_contents($this->user->attachment_cache().'/'."temp.html",$transform);
							shell_exec("wkhtmltopdf " . '--footer-center "FOR OFFICIAL USE ONLY" ' . escapeshellarg($this->user->attachment_cache().'/'."temp.html") . " " 
							. escapeshellarg($this->user->attachment_cache().'/'."temp.pdf") . " 2>&1");
							$pdf = file_get_contents($this->user->attachment_cache().'/'."temp.pdf");						
							header('Content-Type: application/download');
							header("Content-Disposition: attachment; filename=\"" . $filename . ".pdf\"");
							header("Content-Transfer-Encoding: binary");
							echo $pdf;
						}
						else { echo $transform; }
						$this->user->clear_attachment_cache();
					}
					else { //download as usual if transformation fails
						header('Content-Type: application/download');
						header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
						header("Content-Transfer-Encoding: binary");
						echo $string;
					}
				}
			}
			//if not download it as normal
			else {
				header('Content-Type: application/download');
				header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
				header("Content-Transfer-Encoding: binary");
				echo $string;
			}
		}
		else {
			header("Content-Type: application/force-download");
			header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
			header("Content-Transfer-Encoding: binary");
			echo $string;
		}
    }
	
    /* This function takes an image attachment stored in session and loads a view that will display it */
    public function imgdisp($id, $filename, $inline = NULL) {
		if(!Message::formatted_like_an_id($id)) show_404();
		if(!$this->is->nonempty_string($filename)) show_404();
		$filename = rawurldecode($filename);
		
		//find the message && validate
		$message = Message::find_one($id);
		$this->show_error_if_not_a_message($message);
		
			
		//this could should only be called when there is a single inline image taking up the entire body of the message
		//and there is no parts array, a condition that only seems to happen when an image is sent in apple mail
		//inline with no text also included
		if($inline){
			$filename = strtolower($filename);
			if(strtolower($inline) === 'jpg' || strtolower($inline) === 'jpeg' || strtolower($inline) === 'gif' || strtolower($inline) === 'png' || strtolower($inline) === 'tiff') {
				$ContentType = 'image/' . $inline;
				header ("Content-Type: $ContentType"); //set content type in headers
				header('Content-Disposition: attachment; filename="' . $filename . '"');
				echo base64_decode($message->body);
				
			}
			return;
		}
	
		$filename = html_entity_decode($filename);
		if(array_key_exists($filename, $message->attachment_files))
			$attachment = $message->attachment_files[$filename];
		elseif(array_key_exists($filename, $message->inline_attachment_files))
			$attachment = $message->attachment_files[$filename];
		else
			show_404(); //no such attachment for this message
		
		if(in_array(strtolower($attachment->filetype), array('jpg', 'jpeg', 'gif', 'png', 'tiff'))){
			$ContentType = 'image/' . $attachment->filetype;
			header ("Content-Type: $ContentType"); //set content type in headers
			header('Content-Disposition: attachment; filename="' . $filename . '"');
			echo $attachment->binary_string;
		}
		else {
			header('Content-Type: application/force-download');
			header('Content-Disposition: attachment; filename="' . $filename . '"');
			header('Content-Transfer-Encoding: binary');
			echo base64_decode($attachment->binary_string);
		}
    }	
	
	/* This function allows the user to preview an attachment stored in their personal attachment cache
	 */
	public function preview_attachment($filename) {
		$filename = html_entity_decode(rawurldecode($filename));
		$file_path = $this->user->attachment_cache().$filename;
		if(!file_exists($file_path)) show_404();
		
		$file_type = pathinfo($filename, PATHINFO_EXTENSION);
		if($file_type == 'pdf') {
			header('Content-Type: application/pdf');
			header('Content-Disposition: inline; filename="' . $filename . '"');
			echo file_get_contents($file_path);
		}
		else if($file_type == 'jpg' || $file_type == 'jpeg' || $file_type == 'png' || $file_type == 'gif') {
			header('Content-Type: image/'. $file_type);
			header('Content-Disposition: inline; filename="' . $filename . '"');
			echo file_get_contents($file_path);
		}
		else {
			header('Content-Type: application/download');
			header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
			header("Content-Transfer-Encoding: binary");
			echo file_get_contents($file_path);
		}
	}
	
	
/////////////////////////////////////////////////////////////
// PROTECTED
/////////////////////////////////////////////////////////////		
	
	protected function show_attachment_error($message, $status){
		if(!$this->is->nonempty_string($message)) return $this->error->should_be_a_nonempty_string($message);
		if(!$this->is->nonzero_unsigned_integer($status)) return $this->error->should_be_a_nonzero_unsigned_integer($status);
		
		if(IS_AJAX)
			show_error($message, $status);
		else
			echo '<textarea status="'.$status.'">'.$message.'</textarea>';		
	}
	
}
/* End of file inbox.php */
/* Location: ./application/controllers/inbox.php */